/*
    This file is part of the 'ears' package.
    Copyright (C) 1994,1995,1996  Ralf Stephan <ralf@ark.franken.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#pragma implementation
#include <string>
#include "config.h"
#include "pr_config.h"
#include "messages.h"
#include "words.h"
#include "pr_rec_aw.h"
#include "pr_training.h"
#include "pr_train_ears.h"
#include "pr_update_config.h"
#include "exception.h"
#include "tscreen.h"
#include "sound.h"

TrainEarsProtocol::TrainEarsProtocol (int i, char** p)
: argc_(i), argv_(p), wrd_(0), snd_(0)
{
}

TrainEarsProtocol::~TrainEarsProtocol()
{
  if (wrd_) delete wrd_;
  if (snd_) delete snd_;
}

void TrainEarsProtocol::start()
{
  tscreen tscr;
  messages msg;
  
  { ConfigProtocol P (argc_, argv_, false); P.start(); }
  config& cfg = config::InstanceRef();
  
  tscr.change_to_gui_if_possible();

  wrd_ = new words;
  wrd_->try_to_load (cfg["BASENAME"], cfg["EARS_PATH"]);
  if (wrd_->not_loaded())
    if (msg.yesno(M_Default_Words,YES))
      wrd_->make_default_list();
    
  snd_ = new Sound (cfg.iget("SOUND_SPEED"), cfg.iget("SOUND_BITS"));

  tscr.cfg_set(cfg.map()); 
  
  key_type key;
  while ((key = tscr.getkey()) != 0)  // if gui_type==uiRaw, returns RET+ESC
  {
    switch (key)
    {
    case 0x03: throw(fatal_exception("Control-C pressed.")); 

    case 0x0112:
    case 0x1b:   
      return;
    
    case 0x0109: 
      tscr.help();   
      break;

    case 0x010a: 
    {
      string key, contents;
      if (tscr.config (key, contents))
      {
        UpdateConfigProtocol P (key, contents);
        P.start();
        if (!P.updated()) break;
        tscr.cfg_redraw();

        if (key=="BASENAME" || key=="FEATURE")
        {
          delete wrd_;
          wrd_ = new words;
          string f = cfg["FEATURE"];
          string s = cfg["EARS_PATH"] + "/" + f + "-" + cfg.pat_type();
          cfg.set_patpath (s);
          wrd_->try_to_load (cfg["BASENAME"], cfg["EARS_PATH"]);
        }
        else if (key=="SOUND_BITS" || key=="SOUND_SPEED")
        {
          delete snd_;
          snd_ = new Sound (cfg.iget("SOUND_SPEED"), cfg.iget("SOUND_BITS"));
        }
      }
      break;
    }

    case 0x010b:
      cfg.save();
      tscr.note("Configuration saved.");
      break;
      
    case 0x0d:
      wrd_->mark_missing (cfg.pattern_path(), cfg.iget("MIN_NUM_WORDS"));
      if (wrd_->files_incomplete() && msg.yesno (M_Record_New_Words, YES)==YES)
      {
        RecordingAllWordsProtocol P;
        P.start();
        if (P.stopped()) break;
      }
      {
        TrainingProtocol P (cfg["RECOGNIZER"], cfg.bget("DEBUG"));
        P.start();
        if (cfg.training_needed() && msg.yesno (M_Train, YES)==YES)
          P.train();
        if (msg.yesno (M_Write_Trained, YES)==YES)
          P.write();
      }
      break;
    }
  }
}

