/*
    This file is part of the 'ears' package.
    Copyright (C) 1994,1995  Ralf Stephan <ralf@ark.franken.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#pragma implementation 
#include <string>
#include <dirent.h>
#include <stream.h>
#include <fstream.h>
#include <map.h>
#include <list.h>
#include "modules/recognizer.h"
#include "pr_training.h"
#include "exception.h"
#include "config.h"
#include "words.h"

//---------------------------PUBLICS-----------------------------------
TrainingProtocol::TrainingProtocol (const string& r, bool d) 
: net_(r,d)
{
}  

void TrainingProtocol::train()
{
  cout << "Training for " << num_words_ << " words" << endl;
  net_.train ();
}

void TrainingProtocol::write()
{
  config& cfg = config::InstanceRef();
  string nfn 
    = cfg["EARS_PATH"] + "/" + cfg["BASENAME"] + "." + cfg["RECOGNIZER"];
  ofstream file (nfn.c_str());
  file << cfg["RECOGNIZER"] << endl;  // write recog name first
  file << net_;
}

void TrainingProtocol::start()    
{
  num_patterns_ = 0;
  typedef map<string, list<int>, less<string> > SLMap;
  SLMap table;
  
  words& wrd = words::InstanceRef();
  for (string word=wrd.firstlabel(); word.length()>0; word=wrd.nextlabel())
  {  
    table[word] = *new list<int>;  
  }
  num_words_ = table.size();  // what if not all words are sampled?
   
  string path = config::InstanceRef().pattern_path();
  DIR* dp = opendir(path.c_str());
  struct dirent *p;
  while ((p=readdir(dp))!=0)
  {
    string fn = p->d_name;
    if (fn=="." || fn=="..") continue;
    string w = fn.substr(0,fn.find("."));
    SLMap::iterator it = table.find(w);
    if (it != table.end())
    {
      string nr = fn.substr(fn.find(".")+1);
      ((*it).second).push_back (atoi(nr.c_str()));  // append nr to list
      ++num_patterns_;
    }
  }
  closedir(dp);
  if (num_patterns_ < 2) 
    throw(fatal_exception("Not enough patterns")); 

  net_.dimension (num_words_, num_patterns_);

  int wc=0, pc=0;
  for (string word=wrd.firstlabel(); word.length()>0; word=wrd.nextlabel(),wc++)
  {
    list<int>& l = table[word];
    list<int>::iterator it;
    for (it = l.begin(); it!=l.end(); it++,pc++)
    {
      int no = *it;
      string fn = path + "/" + word + "." + dec(no);
      net_.get (fn, wc, pc);
    }
  }
}

