/*
    This file is part of the 'ears' package.
    Copyright (C) 1996  Ralf Stephan <ralf@ark.franken.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#pragma implementation 
#include <stream.h>
#include <fstream.h>
#include "messages.h"
#include "config.h"
#include "pr_update_config.h"
#include "others/mystring.h"

//------------------------------PUBLICS---------------------------------
UpdateConfigProtocol::UpdateConfigProtocol (const string& k, const string& c) 
: key_(k), contents_(c), updated_(false)
{
}

void UpdateConfigProtocol::start()
{
  messages& msg = messages::InstanceRef();
  config& cfg = config::InstanceRef();

  if (key_ == "DEBUG" || key_ == "KEEP_SAMPLES" || key_ == "NEWLINE" ||
      key_ == "TEST"  || key_ == "EXECUTE")
  {
    upcase (contents_);
    if (contents_ == "YES" || contents_ == "NO") 
     ; // gcc-2.7.2 workaround
    else
    {
      msg.note("Can only be \"yes\" or \"no\".  Not changed.");
      updated_ = false;
      return;
    }
    cfg.set (key_, contents_);
    updated_ = true;
  }
  
  else if (key_ == "MIN_NUM_WORDS" || key_ == "SOUND_SPEED" || key_ == "SOUND_BITS")
  {
    int i = atoi(contents_.c_str());
    bool ok;
    if (key_=="MIN_NUM_WORDS")
      ok = i>0;
    else if (key_=="SOUND_BITS")
      ok = i==8 || i==16;
    else if (key_=="SOUND_SPEED")
      ok = i>=8000;
    
    if (ok) { contents_=dec(i); cfg.set(key_,contents_); }
    else msg.note("Value out of range");
    updated_ = ok;
  }

  else if (key_ == "NOCURSES" || key_ == "EARS_PATH" || key_ == "RECOGNIZER")
  {
    msg.note("Can't change that from here.  You have to restart the program\
              with the corresponding option or edit your .earsrc file.");
    updated_ = false;
  }
  
  else if (key_ == "FEATURE")
  {
    upcase (contents_);
    if (contents_ == "MRASTA" || contents_ == "PLP") ; // gcc-2.7.2 workaround
    else
    {
      msg.note("Sorry, MRASTA and PLP are the only feature extractors now.");
      updated_ = false;
      return;
    }
    cfg.set(key_,contents_);
    updated_ = true;
  }
      
  else if (key_ == "BASENAME")
  {
    string fn = cfg["EARS_PATH"] + "/" + contents_ + ".words";
    {
    ifstream f(fn.c_str());
    if (f.good()) { cfg.set(key_,contents_); updated_ = true; return; }
    }
    fn = string("./") + contents_ + ".words";
    ifstream f(fn.c_str());
    if (f.good()) { cfg.set(key_,contents_); updated_ = true; return; }
    string t = fn + " not found.  Config not changed.";
    msg.note(t);
    updated_ = false;
  }

  else 
  {
    msg.note ("Problem in config::update()");
    updated_ = false;
  }
}

