/*
    This file is part of the 'ears' package.
    Copyright (C) 1995  Ralf Stephan <ralf@ark.franken.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#pragma implementation
#include "screen.h"
#include "sound.h"
#include "config.h"
#include "others/time.h"

screen* screen::instance_ = 0;  // is a singleton
//-----------------------------PUBLICS----------------------------------

void screen::change_to_gui_if_possible()
{ 
  UserInterface* p;
  if (!config::InstanceRef().bget("NOCURSES") &&
      (p = UserInterface::make_ui (ui_ncurses, title_)) != 0)
  {
    delete ui_;
    ui_=p;
  }
}


bool screen::recw_stopped()
{
  
  int ch;
  again_ = true;
  if (!ui_->has_raw_keys() || (ch=ui_->getkey_if_available())<0) return false;
  if (ch!=0x03 && ch!='+' && ch!=0x1b) return false;
  
  if (ch==0x03) { throw(fatal_exception("Recording aborted.")); }
  if (ch==0x1b) { again_=false; return true; }
  if (ch=='+')
  {
    Sound::Instance()->deaf_mic();
    ui_->recw_pause(true);
    while (1)
    {
      Time sleep(50000);
      ch = ui_->getkey();
      if (ch==0x03) { throw(fatal_exception("Recording aborted.")); }
      if (ch==0x1b) { again_=false; return true; }
      if (ch=='+')
      {
        Sound::Instance()->full_mic();
        ui_->recw_pause(false);
        return true;
      }
    }
  }
  return true;    

}

bool screen::recw_again()
{
  return again_;
}
