#ifndef Screen_h
#define Screen_h

#pragma interface
#include <string>
#include "ui/user_interface.h"

typedef int key_type;

class screen         // Bridge to the UserInterface, singleton
{
  friend class TrainEarsProtocol;
  friend class ListenProtocol;

public:
  static screen* Instance()    { return instance_; }
  static screen& InstanceRef() { return *instance_; }
  virtual void close()         { delete ui_; ui_=0; }
  
  void change_to_gui_if_possible();
  
  int query (string text, char* keys)
                               { return ui_->query (text, keys); }
  void note (string text)      { ui_->note (text); }
  int getkey (char* keys=0)    { return ui_->getkey(keys); }

  void recw_open()             { ui_->recw_open(); }
  void recw_close()            { ui_->recw_close(); }
  void recw_speak (string s)   { ui_->recw_speak(s); }
  void recw_result (string s)  { ui_->recw_result(s); }
  void recw_ok()               { ui_->recw_ok(); }
  void recw_gauge (int i)      { ui_->recw_gauge(i); }
  bool recw_stopped();
  bool recw_again();
  
  void setRastaTime (int i)    { RastaTime_=i; }
  
protected:
  screen (string title="") : title_(title)
                               { ui_ = UserInterface::make_ui (ui_raw, ""); 
                                 instance_ = this; }
  virtual ~screen()            { close(); }
  UserInterface* ui_;
  int RastaTime_;  

private:
  static screen* instance_;
  const string title_;
  bool again_;

};

#endif
