/*
    This file is part of the 'ears' package.
    Copyright (C) 1996  Ralf Stephan <ralf@ark.franken.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#pragma implementation
#include "exception.h"
#include "modules/sound_interface.h"
#include "status_check.h"
#include "sound.h"

Sound* Sound::instance_ = 0; // is a singleton

Sound* Sound::Instance()    
{ 
  StatusCheck sc(*instance_) __attribute__ ((unused)); 
  return instance_; 
}

Sound* Sound::UncheckedInstance()    
{ 
  return instance_; 
}

Sound& Sound::InstanceRef() 
{ 
  StatusCheck sc(*instance_) __attribute__ ((unused)); 
  return *instance_; 
}

Sound::Sound (int r, int b)
{ 
  s_ = SoundInterface::make_si (r,b);
  instance_ = this;
}

Sound::~Sound() 
{ 
  close();
}

void Sound::close() 
{ 
  if (s_) delete s_;
  s_=0;
}

void Sound::operator >> (class sndblock& b) { s_->fill_block (b); }
void Sound::deaf_mic() const                { s_->deaf_mic(); }
void Sound::full_mic() const                { s_->full_mic(); }
void Sound::empty_buffer() const            { s_->empty_buffer(); }
void Sound::save_sample (const class sample& s, const string& f)
                                            { s_->save_sample(s,f); }

//----------------------------------------------------------------------
const string& Sound::Name() const     { return s_->Name(); }
bool Sound::bad() const               { return s_->bad(); }
const string& Sound::ErrorMsg() const { return s_->ErrorMsg(); }
