#ifndef Sound_h
#define Sound_h
#pragma interface

#include <string>
#include "others/checkable.h"

class Sound : public Checkable       // Bridge to modules/sound_interface
{
  friend class TrainEarsProtocol;
  friend class ListenProtocol;

public:
  static Sound* Instance();
  static Sound* UncheckedInstance();
  static Sound& InstanceRef();
  void close();

  void operator >> (class sndblock&);
  void deaf_mic() const;
  void full_mic() const;
  void empty_buffer() const;
  void save_sample (const class sample&, const string&);
  
  virtual const string& Name() const;
  virtual bool bad() const;
  virtual const string& ErrorMsg() const;

private:
  explicit Sound (int, int);
  virtual ~Sound();
  static Sound* instance_;
  class SoundInterface* s_;
};


#endif

