/*
    This file is part of the 'ears' package.
    Copyright (C) 1995,1996  Ralf Stephan <ralf@ark.franken.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#pragma implementation
#include "speechstream.h"
#include "others/sndblock.h"
#include "sound.h"
#include "modules/sample.h"
#include "screen.h"
#include "exception.h"

int bad_sample, bad_speech;

//----------------------------SPEECHSTREAM--------------------------
speechstream::speechstream (int r, int b) :
    rate_(r), bits_(b), max_blocks_(1000), frame_ms_(20), delay_ms_(200), 
    pause_ms_(300), min_ms_(200), error_(false)
{}

speechstream& speechstream::operator>> (sample& s)
{
  screen &scr = screen::InstanceRef();

  Sound& iss_ = Sound::InstanceRef();
  iss_.full_mic();
  if (s.buf_) { delete [] s.buf_; s.buf_=0; }     // reset sample
  bad_speech = bad_sample = 0;
  if (scr.recw_stopped())
    { bad_sample=scr.recw_again(); return *this; }
  
  sndblock sbl((rate_*frame_ms_)/1000,bits_);
  int e1=0,e2=0,e3=0;
  for (int k=0; k<delay_ms_/frame_ms_; k++)
  {
    iss_ >> sbl;
    e1 = e2;
    e2 = e3;
    e3 = sbl.energy();
    if (sbl.energy()<e_limit_) e_limit_=sbl.energy();
    if (scr.recw_stopped())
      { bad_sample=scr.recw_again(); return *this; }
  }
  e_limit_=(e1+e2+e3)/3;
  if (e_limit_==0) e_limit_=1;
  if (bits_==8) e_limit_ *= 2;
  else          e_limit_ = int(float(e_limit_)*3.0);

  bool started = false;
  int count = 0, pause_count = 0;
  sndblock* sb_array[max_blocks_];

  scr.recw_gauge(0);
  while (1)
  {
    sndblock& block = *new sndblock ((rate_/1000)*frame_ms_,bits_);
    iss_ >> block;
    if (!started)
      while (block.energy() < e_limit_)  
       { 
         iss_ >> block; 
         if (scr.recw_stopped())
         { 
           bad_sample=scr.recw_again();
           delete &block;
           for (int k=0; k<count; k++)
             delete sb_array[k];
           return *this; 
         }
       }
    if (count%5==0) scr.recw_gauge(block.energy()/(bits_==8?1:30));
    if (block.energy() < e_limit_)
    {
      if (++pause_count > pause_ms_/frame_ms_)
      {
        delete &block;
        break;
      }
    }
    else pause_count=0;
    
    started = true;
    sb_array[count++] = &block;
    if (count>=max_blocks_) 
    {
      scr.recw_close();
      throw(fatal_exception("Too much sound!\n"));
    }
  }
  
//  for (int k=0; k<pause_ms_/frame_ms_; k++)     // go back to word end.
//    delete sb_array[--count];             // should we take some frames
                                          // after energy has dropped?    
  if (count < min_ms_/frame_ms_) 
  { 
    bad_sample=1;
    for (int k=0; k<count; k++)
      delete sb_array[k];
    return *this; 
  }

  if (count >= max_blocks_) 
  { 
    bad_speech=1;
    for (int k=0; k<count; k++)
      delete sb_array[k];
    return *this; 
  }
  
  const n = sbl.size();
  s.buf_ = new short [count*n];
  for (int k=0; k<count; k++) 
  {
    memcpy (s.buf_+n*k, sb_array[k]->buf(), n*sizeof(short));
    delete sb_array[k];
  }
  
  s.length_ = count*n;
  s.bits_ = bits_;
  s.rate_ = rate_;
  return *this;
}


