/*
    This file is part of the 'ears' package.
    Copyright (C) 1996  Ralf Stephan <ralf@ark.franken.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#pragma implementation
#include <string>
#include "others/checkable.h"
#include "screen.h"
#include "status_check.h"

StatusCheck::StatusCheck (const Checkable& c)
{
  if (!c.bad()) return;
  
  string s = "class ";
  s += c.Name();
  s += " says: \n";
  s += c.ErrorMsg();
  s += "\n\nBailing out...";
  screen::InstanceRef().note(s);  // Danger.  What if we make screen checkable?
  screen::InstanceRef().close();
  cerr << "Aborted." << endl;
  exit(1);
  
//  throw ( fatal_exception ("StatusCheck failed") ); // not possible without
                                                      // real exceptions
}