/*
    This file is part of the 'ears' package.
    Copyright (C) 1995  Ralf Stephan <ralf@ark.franken.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#pragma implementation
#include <string>
#include "info_cfg.h"
#include "tscreen.h"

tscreen::tscreen() : screen("train_ears"), menu_w_(0), cfg_w_(0)
{
//  show_menu();
}

tscreen::~tscreen() { close(); }

void tscreen::close()
{
  ui_->close_all_wins();
  screen::close();
  delete cfg_i_;
}

//--------------------------------------------------------------
void tscreen::cfg_set (const SSMap& m)
{
  show_menu();                                // kludge
  cfg_w_ = ui_->makeInfow("Configuration");
  cfg_i_ = new InfoCfg (m);
  ui_->infow_fill (cfg_w_, cfg_i_->contents());
}

bool tscreen::config (string& skey, string& scontents)
{
  int key = ui_->menubox("Change config","Choose the configuration entry you want to change:",
    70,cfg_i_->size(),cfg_i_->strings());
  if (key<=0) return false;

  int choice = ui_->choice();
  string oldval,newval;
  oldval = cfg_i_->strings_value(choice);
  string s = "Give the new value for ";
  s += cfg_i_->strings_key(choice);

  key = ui_->inputbox (s,8,50,oldval);
  newval = ui_->getstring();

  if (key<=0 || oldval==newval)
    return false;
    
  skey = cfg_i_->strings_key(choice);
  scontents = newval;
  return true;
}


  
//-------------------------------------------------------------

void tscreen::show_menu()
{
  menu_l_.erase (menu_l_.begin(), menu_l_.end());
  menu_l_.push_back("F1      - Help");
  menu_l_.push_back("F2      - Config");
  menu_l_.push_back("F3      - Save config");
  menu_l_.push_back("Return  - Record samples");
  menu_l_.push_back("F10/Esc - Quit");
  
  menu_w_ = ui_->makeInfow("");
  ui_->infow_fill (menu_w_, menu_l_);
}

void tscreen::cfg_redraw()
{
  ui_->infow_fill (cfg_w_, cfg_i_->contents());
}

