#ifndef Tscreen_h
#define Tscreen_h
#pragma interface

#include <string>
#include <map.h>
#include <list.h>
#include "screen.h"

typedef map<string, string, less<string> > SSMap;
typedef list<string> SList;

class tscreen : public screen          // main screen of the train_ears program
{
public:
  tscreen();   // init and draw screen
  virtual ~tscreen();  // clear screen, reset state as was before
  virtual void close();
  
  void cfg_set (const SSMap&);         // prepare config window, draw it
  bool config (string&, string&);      // change config, put it in strings
  void cfg_redraw();
  
  void help() { ui_->show_file ("HELP.train_ears"); }

private:
  win_hdl menu_w_, cfg_w_;
  class InfoCfg* cfg_i_;
  SList menu_l_;

  void show_menu();  
};

#endif
