#pragma interface
#ifndef words_h
#define words_h

#include <string>
#include <list.h>
#include "cfg_file.h"

struct Word { 
  string label,action; 
  int missing; 
  Word() {}
  ~Word() {}
  Word (const string s1, const string s2, int m) 
                       { label=s1; action=s2; missing=m; }
  Word (const Word& w) { label=w.label; action=w.action; missing=w.missing; }
  Word& operator= (const Word& w) 
                       { label=w.label; action=w.action; missing=w.missing; 
                         return *this; }
  friend bool operator==(Word w1, Word w2) 
                       { return w1.label==w2.label && w1.action==w2.action; }
  friend bool operator<(Word w1, Word w2) 
                       { return w1.label<w2.label; }
  };

class words
{
  friend class TrainEarsProtocol;
  friend class ListenProtocol;

public:
  static words* Instance()    { return instance_; }
  static words& InstanceRef() { return *instance_; }

  void try_to_load (const string&, const string&);
  bool not_loaded() const          { return load_err_; }
  void mark_missing (const string&, int);
  void make_default_list();
  bool files_incomplete() const    { return missing_ > 0; }
  string rnd_missing();

  const string& firstlabel()       { it_ = list_.begin(); 
                                     return (*it_)->label; }
  const string nextlabel()         { it_++; if (it_==list_.end()) return ""; 
                                     return (*it_)->label; }

  const string& operator[](int n) const
  {
    list<Word*>::const_iterator it;
    for (it = list_.begin(); it!=list_.end(); it++,n--) 
      if (n<=0)
        return (*it)->action;
    static string empty("");
    return empty;
  }

private:
  static words* instance_;
  explicit words() : missing_(0), cfp_(0) { instance_=this; }
  ~words() 
  { 
    for (it_ = list_.begin(); it_!=list_.end(); it_++) 
      delete (*it_); 
    if (cfp_) delete cfp_;
  }
  
  list<Word*> list_;
  list<Word*>::iterator it_;
  short missing_;
  cfg_file* cfp_;
  bool load_err_;
  string wfn_;
};

#endif
