/*
    This file is part of the 'ears' package.
    Copyright (C) 1994,1995  Ralf Stephan <ralf@ark.franken.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "ears/exception.h"
#include "others/sighandler.h"
#include "ears/pr_listen.h"

void control_c(int) { throw(fatal_exception("Control-C hit.")); }

bool the_real_main (int argc, char** argv)
{
  const sigint_handler sigint (control_c);
  
  ListenProtocol P (argc, argv);
  P.start();
  
  return true;
}

//void unexp_exception()
//{
//  cerr << "Oops.  Unexpected exception!\n";
//  throw;
//}

int main (int argc, char** argv)
{
//  set_unexpected (unexp_exception);
  
  for (;;)
  {
    try { if (the_real_main (argc,argv)) break; }
#if 0
    catch (fatal_exception &x)
    {
      cerr << "\nException.  Message: "; x=x;
      x.print();
      return 0;
    }
    catch (...)
    {
      cerr << "Exception caught in main.\n";
    }
#endif
  }
  return 0;
}
