#pragma interface
#if !defined(R_bp_h) && defined(R_BP)
#define R_bp_h

#include "recognizer.h"
#include "pattern.h"

class BP : public RecognizerImplementation         // Plain backpropagation
{
protected:
  const float maxerr, thresh;
  const maxepoch;
  int npat,nin,nout,nhid,trace,coeff,empty;
  float *ain,*ahid,*aout,**whi,**who,**pat,**out, theta;
  void build();
  void init_weights();
  inline float errf (float,float);

public:
  explicit BP (bool d) 
  : RecognizerImplementation(d), maxerr(1e-5), thresh(0.1), maxepoch(2000) 
    { empty=1; pat=out=0; }
  virtual ~BP();
  
  virtual void dimension (int words, int patterns);
  virtual void get (const String& fn, int wc, int pc);
  virtual void train();
  virtual int eval (const pattern&);
  virtual void write (ostream&);
  virtual void read  (istream&);
  virtual int training_needed() { return 1; }
  virtual const char* pat_type()    { return "F"; }
};

class BPMT : public BP         // Backprop with Momentum-Term
{
public:
  BPMT (bool d) : BP(d) { empty=1; pat=out=0; }
  virtual void train();
};

#endif