#pragma interface
#if !defined(R_dtw_h) && defined(R_DTW)
#define R_dtw_h

#include "recognizer.h"
#include "modules/pattern.h"
#include "dist_type.h"

class DTW : public RecognizerImplementation
                                  // Dynamic Time Warp from the cookbook
{
public:
  explicit DTW (bool d) : RecognizerImplementation(d), globdist(0) 
    { nref=0; huh_=10; }
  virtual ~DTW() { if (globdist) delete [] globdist; }  
  virtual void dimension (int, int) {}
  virtual void get (const string& fn, int wc, int) 
    { DTW_entry* e = new DTW_entry; e->fn=fn; e->wc=wc; list.push_back(e); }
  virtual void train() {}
  virtual int eval (const pattern&);
  virtual void write (ostream&);
  virtual void read  (istream&);
  virtual int training_needed() { return 0; }
  virtual const char* pat_type()    { return "V"; }
  virtual SList& deb_info();

protected:
  struct DTW_entry { string fn; int wc; var_pattern p; };
  typedef list<DTW_entry*> DTWList;
  DTWList list;
  dist_type* globdist;
  SList debug_l_;
  int nref, ms_;
  float huh_,best_hypothesis;
  
private:                // gcc produced buggy ass ops so make it private
  DTW& operator= (const DTW&) { return *this; }
  virtual float do_dtw (float**,int,float**,int,int) const;
};

class NDTW : public DTW         // more sophisticated Dynamic Time Warp 
{
public:
  NDTW (bool d) : DTW(d) { nref=mr=0; empty=1; huh_=8; }
  virtual ~NDTW();
  virtual void read (istream&);

private:                // gcc produced buggy ass ops so make it private
  NDTW& operator= (const NDTW&) { return *this; }
  virtual float do_dtw (float**,int,float**,int,int) const;
  int mr,empty;
  float **locd,**glbd;
};

#endif