#pragma interface
#if !defined(R_elman_h) && defined(R_ELMAN)
#define R_elman_h

#include "recognizer.h"
#include "pattern.h"

class ELMAN1 : public RecognizerImplementation      // Elman recurrent net
{
protected:
  const float maxerr, thresh;
  const maxepoch;
  int npat,nin,nout,nhid,trace,coeff,empty,*patlen;
  float *ain,*ahid,*acon,*aout,**whi,**whc,**who,**pat,**out,*null, theta;
  void build();
  void init_weights();
  inline float errf (float,float);

public:
  explicit ELMAN1 (bool d) 
  : RecognizerImplementation(d), maxerr(1e-5), thresh(0.1), maxepoch(2000) 
    { empty=1; pat=out=0; }
  virtual ~ELMAN1();
  virtual void dimension (int words, int patterns);
  virtual void get (const String& fn, int wc, int pc);
  virtual void train();
  virtual int eval (const pattern&);
  virtual void write (ostream&);
  virtual void read  (istream&);
  virtual int training_needed() { return 1; }
  virtual const char* pat_type()    { return "V"; }
};

#endif