/*
    This file is part of the 'ears' package.
    The cookbook routines are Copyright (C) 1993 Tony Robinson
    The rest is Copyright (C) 1994  Ralf Stephan <ralf@ark.franken.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#pragma implementation 
#include <string>
#include <stream.h>
#include "r_dtw.h"
#include "r_bp.h"
#include "r_elman.h"
#include "ears/exception.h"

//---------------------------RECOGNIZER---------------------------------
recognizer::recognizer (const string &m, bool debug) : p(0)
{
  if (0) ;
  else
#ifdef R_DTW
  if (m=="DTW")
    p = new DTW (debug);
  else 
  if (m=="NDTW")
    p = new NDTW (debug);
  else 
#endif
#ifdef R_BP  
  if (m=="BP")
    p = new BP (debug);
  else 
  if (m=="BPMT")
    p = new BPMT (debug);
  else 
#endif
#ifdef R_ELMAN  
  if (m=="ELMAN1")
    p = new ELMAN1 (debug);
  else 
#endif  
  {
    string t = "Unknown recognizer: ";
    t += m;
    throw(fatal_exception(t));
  }
}

//------------------------------RECOG------------------------------------
RecognizerImplementation::~RecognizerImplementation() {}


