#pragma interface
#ifndef Recognizer_h
#define Recognizer_h

#include <string>
#include <list.h>

class pattern;
typedef list<string> SList;

class RecognizerImplementation // This ABC and the class below form a bridge
{
public:
  explicit RecognizerImplementation (bool d=0) : debug_(d) {}
  virtual ~RecognizerImplementation() =0;
  virtual void dimension (int, int) =0;
  virtual void get (const string&, int, int) =0;
  virtual void train() =0;
  virtual int eval (const pattern&) =0;
  virtual void write (ostream&) =0;
  virtual void read  (istream&) =0;
  virtual int training_needed() =0;
  virtual const char* pat_type() =0;
  virtual SList& deb_info() =0;

protected:
  bool debug_;
};
  
class recognizer     // The class through which a recog is accessed
{
public:
  recognizer (const string& m, bool debug=0);
  ~recognizer()                 { delete p; }
  void train()                  { p->train(); }
  void dimension (int w, int n) { p->dimension (w,n); }
  void get (const string& s, int wc, int pc) 
                                { p->get (s,wc,pc); }
  int operator<< (const pattern& s) { return p->eval (s); }  // evaluation
  int training_needed()         { return p->training_needed(); }
  const string pat_type()       { return p->pat_type(); }
  SList& deb_info()             { return p->deb_info(); }

  friend ostream& operator<< (ostream& o, const recognizer& p)
	    { (p.p)->write(o); return o; }
  friend istream& operator>> (istream& i, const recognizer& p)
	    { (p.p)->read(i); return i; }
private:
  RecognizerImplementation* p;
};

#endif
