/*
    This file is part of the 'ears' package.
    Copyright (C) 1995  Ralf Stephan <ralf@ark.franken.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#pragma implementation
#include <string.h>
#include "sfiles.h"
#include "sample.h"

sample_format::format_t sample_format::format_ = sample_format::wav;

//---------------------------SAMPLE----------------------------------------
ostream& operator<< (ostream& o, const sample& s)
{
  switch (sample_format::format_)
  {
  case sample_format::au:  s.write_au(o);  break;
  case sample_format::wav: s.write_wav(o); break;
  default: break; //throw(fatal_exception("Riot in sample.cc!")); break;
  }
  return o;
}

void sample::write_wav (ostream& o) const
// Writing the sample as a RIFF WAVE file
{
  waveheader wh;

  wh.main_chunk = 0x46464952;
  wh.length     = sizeof(waveheader)-8 + length_ * ((bits_==8)?1:2); 
  wh.chunk_type = 0x45564157;
  wh.sub_chunk  = 0x20746D66;
  wh.sc_len     = 16;
  wh.format     = 1;
  wh.modus      = 1;
  wh.sample_fq  = rate_;
  wh.byte_p_spl = (bits_ == 8) ? 1 : 2;
  wh.byte_p_sec = wh.sample_fq * wh.modus * wh.byte_p_spl;
  wh.bit_p_spl  = bits_;
  wh.data_chunk = 0x61746164;
  wh.data_length= length_;
  
  o.write (&wh,sizeof(wh));

  if (bits_==8)
    for (int k=0; k<length_; k++)
      o << ((unsigned char)buf_[k]);
  else
    for (int k=0; k<length_; k++)
      o << (unsigned char)((buf_[k]>>8)) << (unsigned char)(buf_[k]&0x00ff) ;
}

void sample::write_au (ostream& o) const
// Writing the sample as a .au file
{
  AuHeader au;

  au.magic         = 0x2e736e64;                        // without header 
  au.dataLocation  = sizeof (AuHeader);                 // so you can listen to it with aplay.
  au.dataSize      = length_ * bits_/8;
  au.dataFormat    = (bits_ == 8) ? 2 : 3;
  au.samplingRate  = rate_; //  8012.821        (CODEC input)
  au.channelCount  = 1;
  strcpy(au.info,"ears sample");
  
  o.write (&au,sizeof(au));


#ifdef ALITTLE_ENDIAN
  if (bits_==16)
    for (int k=0; k<length_; k++){
      o << (unsigned char) ( buf_[k] & 0x00ff);                // unteres Byte
      o << (unsigned char) ((buf_[k] & 0xff00) >> 8);          // oberes Byte
    }
#else
  if (bits_==16)
    for (int k=0; k<length_; k++){
      o << (unsigned char) ((buf_[k] & 0xff00) >> 8);          // oberes Byte
      o << (unsigned char) ( buf_[k] & 0x00ff);                // unteres Byte
    }
#endif
 
  else
  ; //  throw(fatal_exception(("Writing of 8 bit .au not yet implemented!")));
}

