#ifndef Sample_h
#define Sample_h
#pragma interface

#include <stream.h>

ostream& operator<< (ostream&, const class sample&);  

class sample                // sortofa big sndblock, containing a word
{
  friend class speechstream;

public:
  sample()                       { buf_=0; }
  ~sample()                      { delete [] buf_; }
  long len() const               { return length_; }
  int rate() const               { return rate_; }
  int bits() const               { return bits_; }
  short operator[] (int k) const { return buf_[k]; }
  
  void write_au  (ostream&) const;
  void write_wav (ostream&) const;

private:
  short* buf_;
  int rate_,bits_;
  long length_;
};

class sample_format
{
public:
  enum format_t { au, wav };
  friend ostream& operator<< (ostream& o, sample_format::format_t f) 
    { format_ = f;  return o; }
  format_t format() const { return format_; }
  static format_t format_;
};

#endif