#ifndef Sfiles_h
#define Sfiles_h

#include "unistd.h"

  struct waveheader {
    u_long	main_chunk;	/* 'RIFF' */
    u_long	length;		/* filelen */
    u_long	chunk_type;	/* 'WAVE' */

    u_long	sub_chunk;	/* 'fmt ' */
    u_long	sc_len;		/* length of sub_chunk, =16 */
    u_short	format;		/* should be 1 for PCM-code */
    u_short	modus;		/* 1 Mono, 2 Stereo */
    u_long	sample_fq;	/* frequence of sample */
    u_long	byte_p_sec;
    u_short	byte_p_spl;	/* samplesize; 1 or 2 bytes */
    u_short	bit_p_spl;	/* 8, 12 or 16 bit */ 

    u_long	data_chunk;	/* 'data' */
    u_long	data_length;	/* samplecount */
  };
  
typedef struct struct_auheader {
    int magic;               /* magic number SND_MAGIC */
    int dataLocation;        /* offset or pointer to the data */
    int dataSize;            /* number of bytes of data */
    int dataFormat;          /* the data format code */
    int samplingRate;        /* the sampling rate */
    int channelCount;        /* the number of channels */
    char info[13];            /* optional text information */
} AuHeader;
  
  
#endif  
