/*
    This file is part of the 'ears' package.
    Thanks to Niels Thorwirth for porting to AF platforms.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
// code uses AF record routine . Copyright note : 
/*
 * Copyright 1993 by Digital Equipment Corporation, Maynard, Massachusetts.
 * 
 * Permission to use, copy, modify, distribute, and sell this software and its 
 * documentation for any purpose is hereby granted without fee, provided that 
 * the above copyright notice appear in all copies and that both that 
 * copyright notice and this permission notice appear in supporting 
 * documentation, and that the name of Digital not be used in advertising or 
 * publicity pertaining to distribution of the software without specific, 
 * written prior permission.  Digital makes no representations about the 
 * suitability of this software for any purpose.  It is provided "as is" 
 * without express or implied warranty.
 * 
 * DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING 
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL 
 * DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY 
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN 
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF 
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#pragma implementation
#ifdef AF

#include <fstream.h>
#include "others/sndblock.h"
#include "sample.h"
#include "sound_af.h"

extern "C" {
ATime AFRecordSamples (AC ac, ATime startTime, int nbytes,
                                          unsigned char *buf, ABool block);
ATime AFGetTime (AC ac);
void AFCloseAudioConn (AFAudioConn *aud);
AC AFCreateAC (AFAudioConn *aud, ADevice device, unsigned long valuemask,
                                          AFSetACAttributes *attributes);

void AFDisableInput (AC ac, AMask mask, AMask *old_state, AMask *new_state);
void AFEnableOutput (AC ac, AMask mask, AMask *old_state, AMask *new_state);
}

// Opening the sound device and channel, with help from AF-lib. 
// We always open the default device with name "".
// It's not possible to set bits yet.

AFSound::AFSound (int r, int b) : name_("AFSound"), error_(false)
{ 
  rate = r;   // rate depends on record device
  bits = b;   // 8bits lin not jet implemented in AF
  device = -1;
 
  attributes.rec_gain = 0;
  attributes.endian =  ENDIAN;
  attributes.channels = 1;

//  if (bits == 16) bits must be 16. 8 bits is not yet implemented in AF tools
       attributes.type = AFFindEncodeType ("lin16");     // searches for encode-type
//  else if (bits == 8)
//     attributes.type = AFFindEncodeType ("lin8");      // searches for encode-type
//   else {
//     cout << "sound.cc: samplerate: " << bits << " doesn't fit." << endl;
//     throw(fatal_exception());
//   }     

  if (attributes.type == UNKNOWN_ENCODETYPE
      || AF_sample_sizes[attributes.type].samps_per_unit == 0) {
    cout << "sound.cc: unknown encoding type " << "lin" << bits << endl;
    AFPrintKnownEncodeTypes ();
      instance_=0;
      throw(fatal_exception()); 
    }

               // try to open audio connection audio name is always "".
  if ((aud = AFOpenAudioConn ("")) == NULL) {	
    cout << "sound.cc: can't open connection of std. device." << endl;
      instance_=0;
      throw(fatal_exception()); 
    }


  // Find a suitable default device if none is selected (the first device
  // not connected to the phone) that does fit channels, freq, codingtype.
  // exits when no device is available.


  if (device <= -1){ 
    AFDeviceDescriptor * aDev;
    for (device=0; device < aud->ndevices ; device++) {
      aDev = AAudioDeviceDescriptor(aud, device);
      if ((aDev->recNchannels == attributes.channels) && \
	  (aDev->recSampleFreq == rate)   && \
	  (aDev->recBufType ==  attributes.type))  
	break;
      
    }
  }

  if (device >= aud->ndevices) {
     cout << "can't find default device for sound input." << endl;
      instance_=0;
      throw(fatal_exception()); 
    }

  aucon = AFCreateAC (aud, device,
		   ACRecordGain | ACEncodingType |  ACEndian | ACChannels,
		   &attributes);

  cout << "device :" << device <<  endl;

  maskv = 1 << 0;
  
  deaf_mic();
  instance_ = this;
}

AFSound::~AFSound() 
{ 
  AFEnableInput(aucon, old_s, &maskv, &new_s);
  AFCloseAudioConn(aud);
}

void AFSound::deaf_mic() const
{
  Not yet implemented.  Thanks in advance for your contribution.
}

void AFSound::full_mic() const
{
  Not yet implemented.  Thanks in advance for your contribution.
}

void AFSound::empty_buffer() const
{
  Not yet implemented.  Thanks in advance for your contribution.
}

//-------------------------------------------------------------------
void AFSound::fill_block (sndblock& s) const
{
  unsigned char uc;
  short last_us=0;
  long sum=0;
  static unsigned long timeAF = AFGetTime (iss.aucon) ;
  timeAF = AFRecordSamples (iss.aucon,timeAF ,s.size_*2 ,(unsigned char *) s.buf_, ABlock);
  sum =  s.buf_[0];
  for (int k=1; k<s.size_; k++)
    sum += ( s.buf_[k-1]> s.buf_[k])? s.buf_[k-1]-s.buf_[k]: s.buf_[k]-s.buf_[k-1];
  s.energy_ = sum / s.size_;

}

void AFSound::save_sample (const class sample& s, const string& f) const
{
  string fn = f + ".au";
  ofstream sfile (fn.vol_data());
  sfile << sample_format::au << s;
}

#endif