#ifndef Afsound_h
#define Afsound_h
#pragma interface

#ifdef AF

#include <string>
#include <AF/AFlib.h>
#include <AF/AFUtils.h>

#ifdef ALITTLE_ENDIAN
#define ENDIAN ALittleEndian
#else
#define ENDIAN ABigEndian
#endif

class AFSound : public SoundInterface
{
public:
  explicit AFSound (int, int);
  virtual ~AFSound();

  virtual void deaf_mic() const;
  virtual void full_mic() const;
  virtual void empty_buffer() const;
  virtual void fill_block (class sndblock&) const;
  virtual void save_sample (const class sample&, const string&) const;
  
  virtual const string& Name() const      { return name_; }
  virtual bool bad() const                { return error_; }
  virtual const string& ErrorMsg() const  { return errmsg_; }

private:
  int rate,bits,device;
  AC aucon;
  AFSetACAttributes attributes;     
  AFAudioConn *aud;  
  AMask maskv, old_s, new_s;
  string name_, errmsg_;
  bool error_;
};


#endif
#endif