#ifndef Sndint_h
#define Sndint_h
#pragma interface

#include <string>

class SoundInterface            // End of bridge from ears/sound
{
public:
  static SoundInterface* make_si (int, int);
  virtual ~SoundInterface() = 0;

  virtual void deaf_mic() = 0;
  virtual void full_mic() = 0;
  virtual void empty_buffer() const = 0;
  virtual void fill_block (class sndblock&) const = 0;
  virtual void save_sample (const class sample&, const string&) const = 0;
  
  virtual const string& Name() const = 0;
  virtual bool bad() const = 0;
  virtual const string& ErrorMsg() const = 0;
};


#endif

