#ifndef Uss_h
#define Uss_h
#pragma interface

#ifdef OSS

#include <string>
#include "sound_interface.h"

class OssSound : public SoundInterface
{
public:
  explicit OssSound (int, int);
  virtual ~OssSound();

  virtual void deaf_mic();
  virtual void full_mic();
  virtual void empty_buffer() const;
  virtual void fill_block (class sndblock&) const;
  virtual void save_sample (const class sample&, const string&) const;
  
  virtual const string& Name() const      { return name_; }
  virtual bool bad() const                { return error_; }
  virtual const string& ErrorMsg() const  { return errmsg_; }


private:
  const mixer_loudness, rate, bits;
  int sd, md, devices, old_mic, old_volume;
  mutable int dsp_bytes;
  string name_, errmsg_;
  bool error_, opened_;
};


#endif
#endif
