#ifndef Sunsound_h
#define Sunsound_h
#pragma interface

#ifdef SUN

#include <string.h>
#include "sound_interface.h"

class SunSound : public SoundInterface
{
public:
  explicit SunSound (int, int);
  virtual ~SunSound();

  virtual void deaf_mic();
  virtual void full_mic();
  virtual void empty_buffer() const;
  virtual void fill_block (class sndblock&) const;
  virtual void save_sample (const class sample&, const string&) const;
  
  virtual const string& Name() const      { return name_; }
  virtual bool bad() const                { return error_; }
  virtual const string& ErrorMsg() const  { return errmsg_; }

private:
  int bits, bytes_per_unit;
  int audio_fd;
  string name_, errmsg_;
  bool error_;
};


#endif
#endif
