#ifndef Voxwaresound_h
#define Voxwaresound_h
#pragma interface

#ifdef VOXWARE

#include <string>
#include "sound_interface.h"

class VoxwareSound : public SoundInterface
{
public:
  explicit VoxwareSound (int, int);
  virtual ~VoxwareSound();

  virtual void deaf_mic();
  virtual void full_mic();
  virtual void empty_buffer() const;
  virtual void fill_block (class sndblock&) const;
  virtual void save_sample (const class sample&, const string&) const;
  
  virtual const string& Name() const      { return name_; }
  virtual bool bad() const                { return error_; }
  virtual const string& ErrorMsg() const  { return errmsg_; }


private:
  const mixer_loudness, rate, bits;
  int sd, md, devices, old_mic, old_volume;
  string name_, errmsg_;
  bool error_, opened_;
};


#endif
#endif
