#ifndef Heap_ptr_h
#define Heap_ptr_h

#include <assert.h>

template <class T> class auto_ptr 
{ 
public: 
  auto_ptr(T* p=0)              { p_=p; } 
  ~auto_ptr()                   { delete p_; }
  auto_ptr<T>& operator= (T* p) { delete p_; p_=p; return *this; }
  T* operator->() { assert(p_!=0); return p_; }
  T& operator* () { assert(p_!=0); return *p_; }

private: 
  T* p_;
  auto_ptr<T>& operator= (const auto_ptr<T>&);
  auto_ptr               (const auto_ptr<T>&);
};


#if 0
// Shamelessly stolen from the excellent 'C++ FAQs' by Cline/Lomow
// and Meyers' 'More Effective C++'.

#include <stdlib.h>
#include <assert.h>

template <class T>
class auto_ptr
{
public:
  auto_ptr (T* ptr = 0) 
  { ptr_=ptr; }
  ~auto_ptr()      { deallocate(); }
  void deallocate { delete ptr_;  ptr_ = 0; }
  auto_ptr<T>& operator= (T* ptr)
  { deallocate(); ptr_=ptr; return *this; }
  
  T* operator->() { assert(ptr_!=0); return _ptr; }
  T& operator* () { assert(ptr_!=0); return *_ptr; }
  
  T* relinquishOwnership()
  { T* old = ptr_;  ptr_=0;  return old; }
  
private:
  T* ptr_;
  auto_ptr<T>& operator= (const auto_ptr<T>&);
  auto_ptr               (const auto_ptr<T>&);
};
#endif

#endif