#ifndef Checkable_h
#define Checkable_h

#include <string>

// Mixin ABC for objects that provide status checks & error messages

class Checkable
{
public:
  Checkable() {}

  virtual const string& Name() const = 0;
  virtual bool bad() const = 0;
  virtual bool good() const { return !bad(); }
  virtual const string& ErrorMsg() const = 0;
  
};



#endif