#include <string>
#include <function.h>
#include <algo.h>
#include <cctype>


bool not_equal (const string& lhs, const string& rhs)
{
  return !(lhs==rhs);
}

struct toupper : unary_function <char,char>
{
  char operator() (const char& x) { return toupper(x); }
};

struct tolower : unary_function <char,char>
{
  char operator() (const char& x) { return tolower(x); }
};

string& upcase (string& s) 
{ 
  transform (s.begin(), s.end(), s.begin(), toupper);
  return s;
}

string& downcase (string& s) 
{ 
  transform (s.begin(), s.end(), s.begin(), tolower);
  return s;
}

string& capitalize (string& s)
{
  char* S = new char [s.length()+1];
  char* p = S;
  const char* e = s.c_str();
  for (; *e; ++p,++e) 
  {
    bool word_start = isalnum(*e);
    *p = word_start? toupper(*e) : *e;

    if (word_start)
    {
      ++e; ++p;
      for (; *e; ++p,++e) 
      {
        if (isupper(*e))
          *p = tolower(*e);
        else if (isalnum(*e) || *e=='\'' || *e=='_')
          *p = *e;
        else
          break;
      }
      --e; --p;
    }
  }
  *p=0;
  s = S;
  delete [] S;
  return s;
}

string replicate (char c, int n)
{
  return string(n,c);
}
