#ifndef Sighandler_h
#define Sighandler_h

#include "signal.h"

class sigint_handler
{
public:
  explicit sigint_handler (void (*p)(int)) 
  {
    new_.sa_handler = p;
    sigemptyset(&new_.sa_mask);
    new_.sa_flags = 0;
    sigaction (SIGINT, &new_, &old_);
    if (old_.sa_handler != SIG_IGN)
      sigaction (SIGINT, &new_, NULL);
  }
      
private:
  struct sigaction new_,old_;
};

#endif
