#ifndef Sndblock_h
#define Sndblock_h

struct sndblock        // The smallest unit of sound
{
  sndblock (int s, int b) : 
    buf_(new short[s]), size_(s), bits_(b) {}  
  sndblock (const sndblock& s) :
    buf_(new short[s.size_]), size_(s.size_), bits_(s.bits_)
    { memcpy (buf_, s.buf_, sizeof(short)*size_); }  
  ~sndblock() { delete [] buf_; }
  
  short* const buf() const { return buf_; }
  int energy()       const { return energy_; }
  int size()         const { return size_; }
  int bits()         const { return bits_; }

  short* const buf_;
  const size_, bits_;
  int energy_;
};

#endif