#ifndef Time_h
#define Time_h

#include <sys/time.h>
#include <unistd.h>

class Time
{
  struct timeval old,tv;
public:
  Time()               { gettimeofday(&tv,0); }
  explicit Time(int t) { usleep(t); }
  long seed()          { return tv.tv_usec; }
  long stop() 
  { 
    old = tv; 
    gettimeofday(&tv,0);
    return (tv.tv_sec - old.tv_sec)*1000000 + tv.tv_usec - old.tv_usec;
  }
};


#endif
