#ifdef UI_NCURSES
#ifndef CURSESD_H
#define CURSESD_H
#pragma interface

#include "cursesp.h"

//----------------------------------------------------------------------------
// NOTE:  The cursesd source doesn't use any of the menu- or form-functions
// available with ncurses-1.9.4 and above.  It better should, as these
// libraries are very powerful and flexible.  So PLEASE see cursesd as
// an example what is possible without them, although a soon obsolete one. RWS
//----------------------------------------------------------------------------
class NCursesDialog : public NCursesPanel
{
public:
  NCursesDialog (int x, int y, int h, int w, const char* t);
  ~NCursesDialog();

protected:
  void draw_box (int x, int y, int w, int h, int i, int o, const char* title=0);
  void print_autowrap (const char* text, int w, int y, int x);
  void button_bar();
  void print_button (const char* text, int y, int x, bool selected);
  int check_x, item_x;
  
private:
  void color_setup();
  const height_, width_, str_max_len_;
  const char* title_;
};

//--------------------------------------------------------------------
class NCmsgbox : public NCursesDialog
{
public:
  NCmsgbox (const char* title, const char* contents, int x, int y, 
            int h, int w, bool pause=true);
  ~NCmsgbox();
  bool getkey();
};

//--------------------------------------------------------------------
class NCyesno : public NCursesDialog
{
public:
  NCyesno (const char* title, const char* contents, int x, int y, 
            int h, int w);
  ~NCyesno();
  int getkey() { return key_; }
  
private:
  int key_;
};

//--------------------------------------------------------------------
class NCchecklist : public NCursesDialog
{
public:
  NCchecklist (const char *title, const char *prompt, int x, int y, 
        int h, int w, int list_height, int item_no, const char * const * items, 
	bool radio_flag=false, bool menu_flag=false);
  ~NCchecklist() { delete [] choices_;  delete list_; }
  
  int getkey()  { return key_; }
  int choice()  { return choice_; }
  bool* choices() { return choices_; }

private:
  void print_item (NCursesWindow* w, const char* tag, const char *item, 
                   int status, int choice, bool selected, bool radio_flag,
                   bool menu_flag);
  NCursesWindow* list_;
  int key_, choice_;
  bool *choices_;
};

//--------------------------------------------------------------------
class NCradiolist : public NCchecklist
{
public:
  NCradiolist (const char *title, const char *prompt, int x, int y,
	int h, int w, int list_height, int item_no, const char * const * items)
  : NCchecklist (title,prompt,x,y,h,w,list_height,item_no,items,true,false)
  {}
  ~NCradiolist();
};

//--------------------------------------------------------------------
class NCmenubox : public NCchecklist
{
public:
  NCmenubox (const char *title, const char *prompt, int x, int y,
	int h, int w, int list_height, int item_no, const char * const * items)
  : NCchecklist (title,prompt,x,y,h,w,list_height,item_no,items,true,true)
  {}
  ~NCmenubox();
};

//--------------------------------------------------------------------
class NCinputbox : public NCursesDialog
{
public:
  NCinputbox (const char* title, const char* prompt, int x, int y, 
              int h, int w, const char* init=0);
  ~NCinputbox() { delete [] str_; }
  
  const char* getstr() { return str_; }
  int getkey()         { return key_; }
  
private:
  const str_max_len_;
  int key_;
  char* str_;
};

//--------------------------------------------------------------------
class NCtextbox : public NCursesDialog
{
public:
  NCtextbox (const char* title, const char* file, int x, int y, int h, int w);
  ~NCtextbox() { delete [] line_; delete [] buf_; delete text_; }

private:
  void print_page (int heigth, int width);
  void print_position (int heigth, int width);
  void print_line (int row, int width);
  void back_lines (int n);
  char* get_line();
  int get_search_term (char*, int heigth, int width);
  
  NCursesWindow* text_;
  const str_max_len_, buf_size_;
  int page_length_, key_, hscroll_, fd_, file_size_, bytes_read_;
  char *page_, *buf_, *line_;
  bool begin_reached_, end_reached_;
};
#endif
#endif