#ifndef Screen_h
#define Screen_h

#pragma interface
#include "others/mystring.h"
#include "others/auto_ptr.h"
#include "user_interface.h"

class screen
{
public:
  static screen* Instance()    { return instance_; }
  static screen& InstanceRef() { return *instance_; }
  void init ();    // init and draw screen
  virtual void close();
  
  void has_query () { has_query_ = true; }
  void is_curses () { is_curses_ = true; }

  int query (String text, char* keys);
  void note (String text);
  
  int getkey ()           { return ui_->get_key(0,0); }
  int getkey (char* keys) { return ui_->get_key(0,keys); }

protected:
  friend bool the_real_main (int, char**);
  screen (char* title="") 
  : is_curses_(false), has_query_(false), title_(title)
  { instance_ = this; }
  virtual ~screen();            // clear screen, reset state as was before

  bool is_curses_, has_query_;
  
  void showfile (char*);
  
private:
  static screen* instance_;
  auto_ptr<UserInterface*> ui_;
  char* title_;

};

#endif
