#ifndef Ui_ncurses_h
#define Ui_ncurses_h
#pragma interface

#include <string>
#include <list.h>
#include "user_interface.h"
#include "cursesd.h"
#include "win_reg.h"

typedef list<string> SList;

class UIncurses : public UserInterface
{
public:
  explicit UIncurses (string title);
  virtual ~UIncurses();

  virtual bool has_raw_keys() const { return true; }  
  virtual int getkey (char*p=0) const;
  virtual int getkey_if_available (char*p=0) const;
  virtual int query (string, char*) const;
  virtual void note (string) const;
  virtual void show_file (string) const;
  
  virtual int menubox (string, string, int, int, const SSMap&);
  virtual int choice()              { return choice_; }
  virtual int inputbox (string, int, int, string);
  virtual string getstring()        { return inputstr_; }
  
  virtual win_hdl makeInfow (string);
  virtual void infow_close (win_hdl h) { win_reg_.remove (h); }
  virtual void infow_fill (win_hdl, const SList&, bool b=false);
  virtual void close_all_wins();
  
  virtual void recw_open();
  virtual void recw_close();
  virtual void recw_speak (string);
  virtual void recw_result (string);
  virtual void recw_ok();
  virtual void recw_gauge (int);
  virtual void recw_pause (bool);

protected:
  class Menuboxstrings
  {
  public:
    explicit Menuboxstrings (const SSMap&);
    ~Menuboxstrings();
    operator char**() const { return strings_; }
    
  private:
    Menuboxstrings() {}
    char** strings_;
    int size_;
  };
  
private:
  WindowRegistry<NCursesPanel> win_reg_;
  NCursesPanel *std_, *recw_;
  int midx_, midy_, recw_w_, recw_h_, choice_;
  string inputstr_;
};

#endif