/*
    This file is part of the 'ears' package.
    Copyright (C) 1996  Ralf Stephan <ralf@ark.franken.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#pragma implementation
#include <stream.h>
#include "ui_raw.h"

//-------------------------------------------------------------------------
int UIraw::query (string text, char*) const
{
  int key;
  cout << text; 
  char buf[256];
  buf[0]=0;
  cin.getline(buf,255);
  key = (!buf[0])? 0x0d:buf[0];
  return key;
}

void UIraw::note (string s) const { cout << s << endl; cout.flush(); }

int UIraw::getkey (char*) const 
{
  static count=0;
  switch (count++)
  {
    case 0: return 0x0d;
    case 1: return 0x1b;
    default: return 0;
  }
  return 0;
}

void UIraw::infow_fill (win_hdl, const SList& list, bool forced)
{
  if (!forced) return;
  
  for (SList::const_iterator it=list.begin(); it!=list.end(); it++)
    cout << (*it) << endl;
    
  cout.flush();
}

//-------------------------------------------------------------------------
void UIraw::recw_open() {}
void UIraw::recw_close()           { cout << endl << endl; return; }
void UIraw::recw_speak (string s) 
  { cout << "Please speak: " << s << "  "; cout.flush(); return; }
void UIraw::recw_result (string s) { cout << s; cout.flush();  }
void UIraw::recw_ok()              { cout << "OK!" << endl; return; }
void UIraw::recw_gauge (int) {}
void UIraw::recw_pause (bool) {}

//--------------------------empty funcs-----------------------------------

UIraw::UIraw() {}
UIraw::~UIraw() {}
void UIraw::close_all_wins() {}
int UIraw::getkey_if_available (char*) const { return -1; }
void UIraw::show_file (string) const {}
int UIraw::menubox (string, string, int, int, const SSMap&) 
  { return 0; }
int UIraw::choice() { return 0; }
int UIraw::inputbox (string, int, int, string) { return 0; }
string UIraw::getstring() { return string(""); }
win_hdl UIraw::makeInfow (string) { return 0; }
void UIraw::infow_close (win_hdl) {}

