#ifndef Ui_raw_h
#define Ui_raw_h
#pragma interface

#include <string>
#include <list.h>
#include "user_interface.h"

typedef int win_hdl;
typedef list<string> SList;

class UIraw : public UserInterface
{
public:
  UIraw();
  virtual ~UIraw();
  virtual void close_all_wins()      ;
  
  virtual int query (string, char*)  const;
  virtual void note (string)         const ;
  virtual bool has_raw_keys() const { return false; }
  virtual int getkey (char*p=0)      const ;
  virtual int getkey_if_available (char*p=0) const;
  virtual void show_file (string)    const ;
  
  virtual int menubox (string, string, int, int, const SSMap&);
  virtual int choice()               ;
  virtual int inputbox (string, int, int, string) ;
  virtual string getstring()            ;
  
  virtual win_hdl makeInfow (string) ;
  virtual void infow_close (win_hdl) ;
  virtual void infow_fill (win_hdl, const SList&, bool b=false) ;
  
  virtual void recw_open()           ;  // the recording win is special
  virtual void recw_close()          ;
  virtual void recw_speak (string)   ;
  virtual void recw_result (string)  ;
  virtual void recw_ok()             ;
  virtual void recw_gauge (int)      ;
  virtual void recw_pause (bool)     ;
};


#endif
