/*
    This file is part of the 'ears' package.
    Copyright (C) 1996  Ralf Stephan <ralf@ark.franken.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#pragma implementation
#include "user_interface.h"
#include "ui_raw.h"
#ifdef UI_NCURSES
#include "ui_ncurses.h"
#endif

UserInterface* UserInterface::make_ui (ui_t t, string title)
{
#ifndef UI_NCURSES
  if (t==ui_ncurses) t=ui_raw;
#endif

  switch (t)
  {
    case ui_raw:      return new UIraw;
#ifdef UI_NCURSES
    case ui_ncurses:  return new UIncurses (title);
#endif
    default:
      cerr << "Catastrophe: ui# " << t << " requested but not available!\n";
      exit(1); 
      break;
  }
  return 0;
}

UserInterface::~UserInterface() {}