#ifndef User_interface_h
#define User_interface_h
#pragma interface

#include <string>
#include <list.h>
#include <map.h>

enum ui_t { ui_raw, ui_ncurses };
typedef int win_hdl;
typedef list<string> SList;
typedef map<string, string, less<string> > SSMap;

class UserInterface         // Implementation side of bridge from screen
{
public:
  static UserInterface* make_ui (ui_t, string);
  virtual ~UserInterface()           = 0;
  virtual void close_all_wins()      = 0;
  
  virtual int query (string, char*)  const = 0;
  virtual void note (string)         const = 0;
  virtual bool has_raw_keys()        const = 0;
  virtual int getkey (char*p=0)      const = 0;
  virtual int getkey_if_available (char*p=0)      const = 0;
  virtual void show_file (string)    const = 0;
  
  virtual int menubox (string, string, int, int, const SSMap&) 
                                     = 0;
  virtual int choice()               = 0;
  virtual int inputbox (string, int, int, string) = 0;
  virtual string getstring()            = 0;
  
  virtual win_hdl makeInfow (string) = 0;
  virtual void infow_close (win_hdl) = 0;
  virtual void infow_fill (win_hdl, const SList&, bool b=false) = 0;
  
  virtual void recw_open()           = 0;  // the recording win is special
  virtual void recw_close()          = 0;
  virtual void recw_speak (string)   = 0;
  virtual void recw_result (string)  = 0;
  virtual void recw_ok()             = 0;
  virtual void recw_gauge (int)      = 0;
  virtual void recw_pause (bool)     = 0;
};


#endif
