#ifndef Win_reg_h
#define Win_reg_h

#include <vector.h>

typedef int win_hdl;

template <class WindowType> class WindowRegistry
{
public:
  struct WindowInfo        { WindowType* wp; int x,y,w,h; char str[128]; };
  struct WindowEntry       { win_hdl h; WindowInfo i; };
  typedef vector<WindowEntry*> WEvec;

  WindowRegistry() : cache_h(-1), cache_i(&wi_empty_) {}
  void init (int w, int h) { w_=w; h_=h; }
  win_hdl register_new()   { return new_entry(); }

  WindowInfo& operator[] (win_hdl h)
  {
    if (h==cache_h) return *cache_i;
    for (WEvec::iterator it = list_.begin(); it!=list_.end(); it++)
      if ((*it)->h == h)
      {
        cache_h = h;
        return *(cache_i = &((*it)->i));
      }
    return wi_empty_;           // we should throw here
  }

  void adjustxy (win_hdl h)
  {
    for (WEvec::iterator it = list_.begin(); it!=list_.end(); it++)
      if ((*it)->h == h)
      { 
        switch (h)
        {
        case 1:
          (*it)->i.x = w_-1-(*it)->i.w >? 1;  // Upper right
          (*it)->i.y = 1;
          break;
        case 2:
          (*it)->i.x = 1;                     // Upper left
          (*it)->i.y = 1;
          break;
        default:
          (*it)->i.x = (w_-(*it)->i.w)/2;     // Middle bottom
          (*it)->i.y = h_-1-(*it)->i.h >? 1;
        }
      }
  }

  void remove (win_hdl h)
  {
    for (WEvec::iterator it = list_.begin(); it!=list_.end(); it++)
      if ((*it)->h == h)
      {
        delete (*it)->i.wp;
        delete (*it);
        list_.erase (it);
        cache_h = -1;
        return;
      }
  }
  
  win_hdl first_hdl() 
    { it_ = list_.begin(); return (it_>=list_.end())? 0:(*it_)->h; }
  win_hdl next_hdl()
    { return (++it_>=list_.end())? 0:(*it_)->h; }

private:
  WEvec list_;
  WEvec::const_iterator it_;
  int w_,h_;
  win_hdl cache_h;
  WindowInfo wi_empty_, *cache_i;
  
  int new_entry()
  { 
    WindowEntry* p = new WindowEntry; 
    bool slot[128];
    for (int k=0; k<128; k++) 
      slot[k]=false;
    for (WEvec::iterator it = list_.begin(); it!=list_.end(); it++)
      slot[(*it)->h] = true;
    for (int k=1; k<128; k++) 
      if (!slot[k])
        { p->h=k; break; }
    list_.push_back(p); 
    return p->h;
  }

  WindowRegistry (WindowRegistry &) {}
  WindowRegistry& operator= (const WindowRegistry &) { return *this; }
};

#endif