#include <stdlib.h>
#include <String.h>
#include <fstream.h>
#include <vga.h>
#include <vgagl.h>

#define white(x) (224 + x)

class vgascreen
{
  char* font;
public:
  vgascreen() { vga_init(); vga_setmode(G800x600x256); gl_setcontextvga(G800x600x256); }
  ~vgascreen() { vga_setmode(TEXT); delete [] font; }
  
  void background (int r, int g, int b)        { vga_setpalette(0,r,g,b); }
  void setpalette (int no, int r, int g, int b) { vga_setpalette(no,r,g,b); }
  void initfont() { font = new char[256 * 8 * 8 * BYTESPERPIXEL];
                    gl_expandfont(8, 8, white(24), gl_font8x8, font);
                    gl_setfont(8, 8, font); }
  void write (int x, int y, char* s) 
                  { gl_setwritemode(WRITEMODE_OVERWRITE);
                    gl_write(x,y,s); }
  int getkey()    { return vga_getch(); }
  void clear()    { gl_clearscreen(0); }
  void block (int x, int y, int w, int h, int c) { gl_fillbox(x,y,w,h,c); }
};

class fixed_pattern 
{                                    
public:
  float **buf;
  int trace, coeff;
  fixed_pattern (String& fn);
  ~fixed_pattern() 
  { 
    for (int k=0; k<trace; k++) 
      delete [] buf[k];
    delete [] buf; 
  }
  float* operator[](int i) { return buf[i]; }
};

vgascreen screen;

//--------------------------------------------------------------------
fixed_pattern::fixed_pattern (String& fn) 
{
  ifstream i(fn);
  i >> trace >> coeff;
  
  buf = new float* [trace];
  for (int k=0; k<trace; k++)
    buf[k] = new float [coeff];
  
  for (k=0; k<trace; k++)
    for (int l=0; l<coeff; l++)
      i >> buf[k][l];
}

//--------------------------------------------------------------------------
void showpage (char* files[6])
{
  const x_start=20, b_w=10, b_h=10;
  screen.clear();
  for (int i=0; i<6; i++)
  {
    if (!files[i]) break;
    fixed_pattern p(files[i]);
    const y_start=i*100+10;
    screen.write (x_start,y_start,files[i]);
    for (int j=0; j<p.coeff; j++)
      for (int k=0; k<p.trace; k++)
        screen.block (x_start+b_w*k, y_start+b_h*j+10, b_w, b_h,int((p[k][j]+1)*100.0));
  }
}

//--------------------------------------------------------------------------
main (int argc, char* argv[])
{
  if (argc<2) exit(1);
  
  screen.background (0,250,0);
  for (int i=0; i<250; i++)
    screen.setpalette (i+6,250,250-i,250-i);
  screen.initfont();

  int page = 1;
  while (1)
  {
    if (page<1) page=1;
    if (page>(argc+4)/6) page=(argc+4)/6;
    
    char* files[6];
    for (i=0; i<6; i++) 
    {
      files[i]=argv[(page-1)*6+i+1];
      if (!files[i]) break;
    }
    
    showpage (files);
    
    int c = screen.getkey();
    switch (c)
    {
      case ' ':
      case '\r': ++page; break;
      case 'b':  --page; break;
      case 'q': exit(0);
    }
  }
}
