/*********************************************************************************
 *
 * $Id: buffer.h,v 1.6 1998/06/14 12:55:01 daniel Exp $
 *
 * $Log: buffer.h,v $
 * Revision 1.6  1998/06/14 12:55:01  daniel
 * stop_level calibration has to be done by the user by adjusting MIC IN within kmix!
 *
 * Revision 1.5  1998/06/02 10:33:42  daniel
 * microphone calibration added
 *
 * Revision 1.4  1998/04/29 02:09:02  daniel
 * record(), play() and detect_speech() return bool now instead of void
 *
 * Revision 1.3  1998/04/27 19:44:52  daniel
 * now emitting new signal recording_active, used for LED-control
 *
 * Revision 1.2  1998/04/27 00:22:03  daniel
 * added misc get/set functions needed for the implementation of
 * the options dialog.
 *
 * Revision 1.1  1998/04/26 15:57:31  daniel
 * Initial revision
 *
 *
 *********************************************************************************/

#ifndef BUFFER_H
#define BUFFER_H

#include <qobject.h>

#include "soundcard.h"

class QDialog;
class QLabel;

/* ---------------------------------------------------------------------- */
/*  excerpted from KRecord ...                                            */
/* ---------------------------------------------------------------------- */

class SoundBuffer : public QObject 
{
  Q_OBJECT
  
private:

  short *buffer;
  
  int  position;
  int  position_play;
  int  size;

  Soundcard    *card;
 
  int          rec_level,stop_level,wait,level_distance;
  
  bool         recording, playing;
  
  void         *prefetch;
  int          prefetch_N;
  int          prefetch_pos;

  int accept_low_N;
  int accept_low_count;
  
  bool         get_another_buffer;
  int          postfetch_N;
  int          postfetch_count;

  bool replay;

  bool do_calibrate;
  int calibrate_what; // ***** -1=init, 0=nothing, 1=start_level, 2=stop_level
  int calibrate_count;
  int cal_stop_level;
  int cal_start_level_sum;
  int cal_start_level_min;
  int cal_start_level_count;
  int cal_start_level;

  QDialog *stop_level_dlgbox;
  QLabel  *stop_level_msg;
   
  bool record();
  void stop();

public:

  SoundBuffer();
  ~SoundBuffer();

  bool play();
 
  void *read_audio(int len);
  int   write_audio(int len, void *data);
  int   prefetch_audio(int len, void *data);
  
  bool detect_speech(bool);
  void set_stop_level(int l);
  
  void do_replay(bool);
  short *get_data();
  int get_size();

  int get_acc_sil_frames() {return accept_low_N;};
  int get_rec_level_threshold() {return rec_level;};

signals:

  void recording_active();
  void end_detected();
  
public slots:

  void new_data(void *data);
  void post_data(void *data);

  void set_accept_silence(int val) {accept_low_N = val;};
  void set_rec_level_threshold(int val) {rec_level = val;};

  void calibrate_micro();
  void cal_stop_level_done();
};

#endif
