/*********************************************************************************
 *
 * $Id: kvoicecontrol.cpp,v 1.12 1998/09/25 19:24:27 daniel Exp $
 *
 * $Log: kvoicecontrol.cpp,v $
 * Revision 1.12  1998/09/25 19:24:27  daniel
 * version++ 0.1 -> 0.11
 *
 * Revision 1.11  1998/06/14 13:23:24  daniel
 * version++ 0.09 -> 0.1
 *
 * Revision 1.10  1998/06/02 10:32:51  daniel
 * microphone calibration menu entry added
 *
 * Revision 1.9  1998/05/05 11:16:30  daniel
 * import speakerfile added to speakermodel.[cpp|h]
 *
 * Revision 1.8  1998/05/01 21:44:21  daniel
 * version++ 0.06 -> 0.09
 *
 * Revision 1.7  1998/05/01 21:17:00  daniel
 * constructor accepts speakerfile name now (that was extracted from the command line)
 * if specified, speakerfile is loaded and recognition mode is entered!
 * TrainDialog now accessible via Options menu
 *
 * Revision 1.6  1998/04/29 23:13:29  daniel
 * version++ 0.03 -> 0.06
 *
 * Revision 1.5  1998/04/29 02:19:38  daniel
 * KVoiceControl *kvoicecontrol  ... is global now (needed by DockWidget)
 * DockWidget introduced
 * tiny_mode stuff removed !
 * closeEvent() method needed for interaction with DockWidget
 *
 * Revision 1.4  1998/04/28 00:02:25  daniel
 * led_recognition working correctly now!
 *
 * Revision 1.3  1998/04/27 20:02:12  daniel
 * led_record and led_recognition added
 * led_recognition not yet working correctly!
 * tiny mode added (can be used during recognition mode; just displays the two LEDs)
 *
 * Revision 1.2  1998/04/27 00:24:50  daniel
 * options menu and options editor added
 * KConfig object introduced
 *
 * Revision 1.1  1998/04/26 15:57:00  daniel
 * Initial revision
 *
 *
 *********************************************************************************/

#include <qkeycode.h>
#include <qaccel.h>
#include <kiconloader.h>
#include <klocale.h>
#include <qmsgbox.h>
#include <kconfig.h>
#include <qrect.h>

#include "docking.h"

#include "kvoicecontrol.moc"

#include <iostream.h>

#define _(TEXT) klocale->translate(TEXT)

KApplication  *globalKapp;
KIconLoader   *globalKIL;
KVoiceControl *kvoicecontrol;
DockWidget    *dock_widget;

int main(int argc, char **argv)
{
  if (argc != 1 && argc != 2)
  {
    cerr << "Usage: " << *argv[0] << " [<speakerfile.spk>]" << endl;
    exit(1);
  }

  globalKapp = new KApplication( argc, argv, "kvoicecontrol");
  globalKIL  = globalKapp->getIconLoader();
  dock_widget = new DockWidget("dock_kvoicecontrol");
  dock_widget->dock();

  if (argc == 0)
    kvoicecontrol = new KVoiceControl(0);
  else
    kvoicecontrol = new KVoiceControl(argv[1]);
  return globalKapp->exec();
}


/* *******************************************************************************
**
** Constructor
**
******************************************************************************* */

KVoiceControl::KVoiceControl(char *speakerfile)
{
  speakermodel = new SpeakerModel(globalKapp->getConfig(), this, "spkm");

  globalKapp->setMainWidget(speakermodel);
  create_menu();
    
  connect(speakermodel, SIGNAL(new_title(QString)), this, SLOT(set_title(QString)));
  connect(speakermodel, SIGNAL(detect_mode_changed(bool)), this, SLOT(set_detect(bool)));
  //connect(speakermodel, SIGNAL(detect_mode_changed(bool)), dock_widget, SLOT(set_detect(bool)));

  speakermodel->reset();
  uint minY = main_menu->height();
  speakermodel->setGeometry(5, minY+5, 300, 200);
  
  resize(310,210+2*minY);
  //show();
  setMinimumSize( 310, 210+2*minY );
  setMaximumSize( 310, 210+2*minY );

  if (speakerfile != NULL)
  {
    speakermodel->load(speakerfile, true);
    speakermodel->detect_mode_on();
  }
  else
    show();
}


/* *******************************************************************************
**
** Destructor
**
******************************************************************************* */

KVoiceControl::~KVoiceControl()
{
  delete speakermodel;

  delete file_menu;
  delete opt_menu;
  delete help_menu;
  delete main_menu;
}


/* *******************************************************************************
**
** about
**
******************************************************************************* */

void KVoiceControl::about()
{
  speakermodel->detect_mode_off();

  QMessageBox::about(this, "About...",
		     "kvoicecontrol 0.11\n\n"
		     "(c) 1998 Daniel Kiecza <kiecza@ira.uka.de>");
}


/* *******************************************************************************
**
** create_menu
**
******************************************************************************* */

void KVoiceControl::create_menu()
{
  file_menu = new QPopupMenu;
  file_menu->insertItem( _("&New"), speakermodel, SLOT(reset()));
  file_menu->insertSeparator();
  file_menu->insertItem( _("&Load"), speakermodel, SLOT(load()));
  file_menu->insertItem( _("&Save"), speakermodel, SLOT(save()));
  file_menu->insertItem( _("Save &as..."), speakermodel, SLOT(save_as()));
  file_menu->insertSeparator();
  file_menu->insertItem( _("&Import ..."), speakermodel, SLOT(import()));
  file_menu->insertSeparator();
  file_menu->insertItem( _("&Quit"), this, SLOT(quit()), CTRL+Key_Q);
  
  rec_menu = new QPopupMenu;
  detect_ID = rec_menu->insertItem( _("&Recognition Mode"), speakermodel, SLOT(toggle_detect_mode()), CTRL+ALT+Key_R);
  rec_menu->setCheckable( TRUE );
  
  connect(dock_widget, SIGNAL(toggle_detect_mode()), speakermodel, SLOT(toggle_detect_mode()));

  QAccel *b = new QAccel(this);
  b->connectItem(b->insertItem(CTRL+ALT+Key_R), speakermodel, SLOT(toggle_detect_mode()));

  opt_menu = new QPopupMenu;
  opt_menu->insertItem( _("&Options ..."), speakermodel, SLOT(show_options()));
  opt_menu->insertSeparator();
  opt_menu->insertItem( _("&Train From File ..."), speakermodel, SLOT(train_references()));
  opt_menu->insertSeparator();
  opt_menu->insertItem( _("&Calibrate Micro ..."), speakermodel, SLOT(calibrate_micro()));

  help_menu = new QPopupMenu;
  help_menu->insertItem( _("&Help"), this, SLOT(help()),Key_F1);
  help_menu->insertSeparator();
  help_menu->insertItem( _("&About..."), this, SLOT(about()));
  
  main_menu = new KMenuBar(this, "main menu");
  main_menu->insertItem( _("&File"), file_menu);
  main_menu->insertItem( _("&Action"), rec_menu);
  main_menu->insertItem( _("&Options"), opt_menu);
  main_menu->insertSeparator();
  main_menu->insertItem( _("&Help"), help_menu);
  
  setMenu(main_menu);
}

  
/* *******************************************************************************
**
** help
**
******************************************************************************* */

void KVoiceControl::help()
{
  globalKapp->invokeHTMLHelp("", "");
}


/* *******************************************************************************
**
** quit
**
******************************************************************************* */

void KVoiceControl::quit()
{
  speakermodel->detect_mode_off();

  if (speakermodel->has_changed())
  {
    if (speakermodel->ask_save_changes())
    {
      speakermodel->save_config(globalKapp->getConfig());
      exit(0);
    }
  }
  else 
  {
    speakermodel->save_config(globalKapp->getConfig());
    exit(0);
  }
}


/* *******************************************************************************
**
** set_detect
**
******************************************************************************* */

void KVoiceControl::set_detect(bool do_detect)
{
  rec_menu->setItemChecked( detect_ID, do_detect );
}


/* *******************************************************************************
**
** set_title
**
******************************************************************************* */

void KVoiceControl::set_title(QString title)
{
  setCaption(title);
}



void KVoiceControl::closeEvent(QCloseEvent *)
{
  dock_widget->toggle_window_state();
  //e->ignore();
}


