/*********************************************************************************
 *
 * $Id: kvoicecontrol.h,v 1.5 1998/05/01 21:15:43 daniel Exp $
 *
 * $Log: kvoicecontrol.h,v $
 * Revision 1.5  1998/05/01 21:15:43  daniel
 * constructor accepts speakerfile name now (that was extracted from the command line)
 *
 * Revision 1.4  1998/04/29 02:17:02  daniel
 * tiny_mode removed !
 * closeEvent introduced for proper interaction with DockWidget!
 *
 * Revision 1.3  1998/04/27 20:02:06  daniel
 * led_record and led_recognition added
 * led_recognition not yet working correctly!
 * tiny mode added (can be used during recognition mode; just displays the two LEDs)
 *
 * Revision 1.2  1998/04/27 00:23:51  daniel
 * options menu added
 *
 * Revision 1.1  1998/04/26 15:56:46  daniel
 * Initial revision
 *
 *
 *********************************************************************************/

#ifndef KVOICECONTROL_H
#define KVOICECONTROL_H

#include <qpopmenu.h>
#include <kapp.h>
#include <kmenubar.h>
#include <ktopwidget.h>
#include <qrect.h>

#include "speakermodel.h"


class KVoiceControl : public KTopLevelWidget
{
  Q_OBJECT

public:

    KVoiceControl(char *speakerfile);
    ~KVoiceControl();

    SpeakerModel  *speakermodel;

public slots:

    void about();
    void help();
    void quit();

    void set_title(QString title);
    void set_detect(bool do_detect);

private:

    void create_menu();
    void closeEvent(QCloseEvent *e);

    KMenuBar      *main_menu;
    QPopupMenu    *file_menu;
    QPopupMenu    *rec_menu;
    QPopupMenu    *opt_menu;
    QPopupMenu    *help_menu;
    
    int detect_ID;

    QRect *menu_geometry;
};

#endif


