/*********************************************************************************
 *
 * $Id: reference_editor.cpp,v 1.2 1998/04/27 00:25:53 daniel Exp $
 *
 * $Log: reference_editor.cpp,v $
 * Revision 1.2  1998/04/27 00:25:53  daniel
 * did some code cleaning, so that sound replaying works fine now!
 *
 * Revision 1.1  1998/04/26 15:56:38  daniel
 * Initial revision
 *
 *
 *********************************************************************************/

#include "reference_editor.moc"

#include <qlabel.h>
#include <qframe.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qlistbox.h>
#include <qdatetm.h> 

#include <iostream.h>

#include "preprocessing.h"
#include "buffer.h"


ReferenceEditor::ReferenceEditor( Reference *_r, Preprocessing *_p, SoundBuffer *_b,
				  QWidget *parent=0, const char *name=0 ) : QDialog( parent, name, TRUE )
{
  setCaption("Reference Editor");

  setMinimumSize( 400, 370 );
  setMaximumSize( 400, 370 );
  resize(400, 370);
 
  QLabel *textLabel = new QLabel("Text:", this);
  textLabel->setGeometry(5,5, 60,25);
  textLabel->setAlignment( AlignVCenter | AlignRight );
  text = new QLineEdit(this, "entry_text");
  text->setGeometry(70,5, 300,25);

  QLabel *cmdLabel = new QLabel("Command:", this);
  cmdLabel->setGeometry(5,40, 60,25);
  cmdLabel->setAlignment( AlignVCenter | AlignRight );
  cmd = new QLineEdit(this, "entry_cmd");
  cmd->setGeometry(70,40, 300,25);

  QLabel *smpLabel = new QLabel("Sample Utterances:", this);
  smpLabel->setGeometry(10,80, 150,25);

  smp_listbox = new QListBox( this, "smp_listbox" );
  smp_listbox->setGeometry(12, 103, 200, 200);

  QPushButton *delete_sample_utt = new QPushButton( "Delete", this, "delete_sample_utt" );
  delete_sample_utt->setGeometry(250, 170, 100, 50);
  connect(delete_sample_utt,  SIGNAL(clicked()), this, SLOT(delete_sample()));

  QPushButton *ok = new QPushButton( "Ok", this );
  ok->setGeometry(150, 330, 100, 30);
  connect( ok, SIGNAL(clicked()), this, SLOT(my_accept()) );
  
  reference = _r;
  preprocessing = _p;
  buffer = _b;

  connect(buffer, SIGNAL(end_detected()), this, SLOT(stop_recording()));
  buffer->detect_speech(true);
  buffer->do_replay(true);

  // ***** fill in data from reference ......

  text->setText(reference->get_name());
  cmd->setText(reference->get_command());
  for (uint i = 0 ; i < reference->count() ; i++)
    smp_listbox->insertItem(*(reference->get_sample_name(i)));
}


ReferenceEditor::~ReferenceEditor()
{
  delete text;
  delete cmd;
  delete smp_listbox;
}


void ReferenceEditor::stop_recording()
{
  QDateTime dt = QDateTime::currentDateTime();
  QString name = dt.toString();
  name.prepend("[");
  name.append("]");

  smp_listbox->insertItem(name);
  smp_listbox->setCurrentItem(smp_listbox->count()-1);
  
  reference->append_sample_utterance(preprocessing->preprocess_utterance(buffer->get_data(), 
									 buffer->get_size()));
  buffer->detect_speech(true);
}


void ReferenceEditor::delete_sample()
{
  // ***** delete actual list box entry if one selected

  if (-1 != smp_listbox->currentItem())
  {
    uint idx = smp_listbox->currentItem();
    smp_listbox->removeItem(idx);
    reference->remove_sample_utterance(idx);
  }
}


void ReferenceEditor::my_accept()
{
  // ***** store data into reference ....

  buffer->detect_speech(false);
  buffer->do_replay(false);
  disconnect(buffer, SIGNAL(end_detected()), this, SLOT(stop_recording()));

  reference->set_name(text->text());
  reference->set_command(cmd->text());
  reference->reset_sample_names();
  for ( uint i = 0; i < smp_listbox->count(); i++)
    reference->append_sample_name(smp_listbox->text(i));

  accept();
}
