/*********************************************************************************
 *
 * $Id: reference_editor.h,v 1.1 1998/04/26 15:55:47 daniel Exp $
 *
 * $Log: reference_editor.h,v $
 * Revision 1.1  1998/04/26 15:55:47  daniel
 * Initial revision
 *
 *
 *********************************************************************************/

#ifndef REFERENCEEDITOR_H
#define REFERENCEEDITOR_H

#include <qdialog.h>
//#include <qstring.h>
#include <qlist.h>

class QPushButton;
class QListBox;
class QLineEdit;
class Preprocessing;
class SoundBuffer;

#include "reference.h"

class ReferenceEditor : public QDialog
{
  Q_OBJECT

public:

  ReferenceEditor( Reference *_r, Preprocessing *_p, SoundBuffer *_b,
		   QWidget *parent=0, const char *name=0);
  ~ReferenceEditor();
 
public slots:

  void stop_recording();
  void delete_sample();
  void my_accept();

private:

  QList<Utterance> *smp_list;
  QListBox *smp_listbox;

  QLineEdit *text;
  QLineEdit *cmd;

  Reference     *reference;
  Preprocessing *preprocessing;
  SoundBuffer   *buffer;
};

#endif


