/*********************************************************************************
 *
 * $Id: score.h,v 1.4 1998/04/29 22:19:38 daniel Exp $
 *
 * $Log: score.h,v $
 * Revision 1.4  1998/04/29 22:19:38  daniel
 * all scoring done within this class, as one could expect !!! ;-)
 * introduced Branch&Bound-scoring; fast as HELL!!
 *
 * Revision 1.3  1998/04/28 11:20:55  daniel
 * score_threshold moved from speakermodel to this class
 * we are doing online rejection now! -> performance improvement!
 *
 * Revision 1.2  1998/04/27 00:21:07  daniel
 * get/set_adjust_win_width implemented
 *
 * Revision 1.1  1998/04/26 15:54:55  daniel
 * Initial revision
 *
 *
 *********************************************************************************/

#ifndef SCORE_H
#define SCORE_H

#include <qobject.h>
#include <qlist.h>
#include <qstring.h>

#include "utterance.h"
#include "reference.h"

#define MAX2(a,b) ((a>b)?(a):(b))
#define MIN2(a,b) ((a<b)?(a):(b))
#define MIN3(a,b,c) ( (a<b)?(MIN2(a,c)):(MIN2(b,c)) )

class Score : public QObject
{
  Q_OBJECT

public:

  Score();
  ~Score();

  QString *score(const Utterance *, QList<Reference> *);
  QString *branchNbound_score(const Utterance *, QList<Reference> *);

  float score(const Utterance *, const Utterance *);
  int get_adjust_win_width() {return adjustment_width;};
  float get_threshold() {return threshold;};
  float get_min_distance() {return min_distance;};

public slots:

  void set_adjust_width(int val) {adjustment_width =val;};
  void set_threshold(float val) {threshold =val;};
  void set_min_distance(float val) {min_distance = val;};


private:

  float euklid_distance(const float *, const float *);

  float **DTW_matrix;
  int adjustment_width;
  float threshold;
  float min_distance;
};


class BBQueueItem
{
public:
  BBQueueItem( float _s, uint _i, uint _p ) { sc=_s; idx=_i; p=_p; }
  float  score() const { return(sc); }
  uint  plane_index() const { return(idx); }
  uint pos()   const { return(p); }

  void set_score(float _s)      { sc=_s; }
  void set_plane_index(uint _i) { idx=_i; }
  void set_pos(uint _p)         { p=_p; }

  void step_right() { p++; }
  
private:
  float sc;
  uint idx;
  uint p;
};


#endif

