/*********************************************************************************
 *
 * $Id: speakermodel.h,v 1.10 1998/06/02 10:33:07 daniel Exp $
 *
 * $Log: speakermodel.h,v $
 * Revision 1.10  1998/06/02 10:33:07  daniel
 * microphone calibration added
 *
 * Revision 1.9  1998/05/05 11:16:47  daniel
 * <import speakerfile> added
 *
 * Revision 1.8  1998/05/01 21:13:13  daniel
 * TrainDialog introduced (for training commands extracted from a file)
 *
 * Revision 1.7  1998/04/29 22:16:13  daniel
 * min_distance moved to score now (all scoring is done within score now, as it should be done)
 *
 * Revision 1.6  1998/04/29 02:12:56  daniel
 * tiny_mode removed -> now using docking to panel!!!
 * LED lamps removed (moved onto docking_widget infact)
 * #include's moved to speakermodel.cpp as far as possible ->
 *   in speakermodel.h just keep class definitions (e.g. class SoundBuffer;)
 *
 * Revision 1.5  1998/04/28 11:19:43  daniel
 * score_threshold moved to class Score now -> online rejection!
 *
 * Revision 1.4  1998/04/28 00:00:27  daniel
 * LED timer introduced and kapp.h included to enforce event handling during
 * scoring process (Xflush etc.)
 *
 * Revision 1.3  1998/04/27 20:01:59  daniel
 * led_record and led_recognition added
 * led_recognition not yet working correctly!
 * tiny mode added (can be used during recognition mode; just displays the two LEDs)
 *
 * Revision 1.2  1998/04/27 00:28:06  daniel
 * save_config introduced
 * options dialog implemented
 *
 * Revision 1.1  1998/04/26 15:57:10  daniel
 * Initial revision
 *
 *
 *********************************************************************************/

#ifndef SPEAKERMODEL_H
#define SPEAKERMODEL_H

#include <qwidget.h>
#include <qstring.h>
#include <qfile.h>
#include <qlist.h>
#include <kconfig.h>
#include <qtimer.h>

#include <kapp.h>

class QFileDialog;
class QListBox;
class QPushButton;

class ReferenceEditor;
class Preprocessing;
class SoundBuffer;
class Score;
class Options;

#include "reference.h"


class SpeakerModel : public QWidget
{
  Q_OBJECT

public:

  SpeakerModel(KConfig *config, QWidget *parent=0, const char *name=0);
  ~SpeakerModel();

  bool has_changed();
  bool ask_save_changes();
  bool check_references();

  void save_config(KConfig *);

  void load(char *f=0, bool reset_first=true);

public slots:

  bool reset();
  void load();
  void import();
  void save();
  void save_as();
  
  void test_utterance();

  void new_reference();
  void edit_reference();
  void delete_reference();

  void append_reference(Reference *);

  void detect_mode_on();
  void detect_mode_off();
  void toggle_detect_mode();

  void show_options();

  void train_references();

  void calibrate_micro();
  
  //void set_min_distance(float val) {min_distance = val;};

signals:
  
  void new_title(QString title);
  void detect_mode_changed(bool detect);

private:

  QString          *filename;
  QFileDialog      *fdialog;

  QListBox         *ref_listbox;
  QList<Reference> *ref_list;

  ReferenceEditor  *ref_editor;

  Score            *score;
  Preprocessing    *preprocessing;
  SoundBuffer      *buffer;

  bool             do_detect;
  bool             changed;

  Options          *options_dlg;

  QTimer           *led_timer;

  QPushButton *new_reference_btn;
  QPushButton *edit_reference_btn;
  QPushButton *delete_reference_btn;
};

#endif

