/*********************************************************************************
 *
 * $Id: utterance.cpp,v 1.1 1998/04/26 15:51:59 daniel Exp $
 *
 * $Log: utterance.cpp,v $
 * Revision 1.1  1998/04/26 15:51:59  daniel
 * Initial revision
 *
 *
 *********************************************************************************/

#include"utterance.moc"


/* *******************************************************************************
**
** Constructor
**
******************************************************************************* */

Utterance::Utterance()
{
  size = 0;
  data = NULL;
}


/* *******************************************************************************
**
** Constructor
**
******************************************************************************* */

Utterance::Utterance(float **_data, int _size)
{
  data = _data;
  size = _size;
}


/* *******************************************************************************
**
** Destructor
**
******************************************************************************* */

Utterance::~Utterance()
{
  if (data != NULL)
  {
    for (int i=0; i<size; i++)
      delete data[i];
    delete data;

    data = NULL;
  }
}


/* *******************************************************************************
**
** set_data
**
******************************************************************************* */

void Utterance::set_data(float **_data, int _size)
{
  if (data != NULL)
  {
    for (int i = 0 ; i < size ; i++)
      delete data[i];
    delete data;
  }
  
  data = _data;
  size = _size;
}


/* *******************************************************************************
**
** set_data
**
******************************************************************************* */

void Utterance::set_data(int i, int j, float f)
{
  if (data != NULL)
    data[i][j] = f;
}


/* *******************************************************************************
**
** get_data
**
******************************************************************************* */

float **Utterance::get_data()
{
  return data;
}


/* *******************************************************************************
**
** get_data
**
******************************************************************************* */

float Utterance::get_data(int i, int j) const
{
  return data[i][j];
}


/* *******************************************************************************
**
** set_size
**
******************************************************************************* */

void Utterance::set_size(int _size)
{
  if (data != NULL)
  {
    for (int i = 0 ; i < size ; i++)
      delete data[i];
    delete data;

    data = NULL;
  }
  size = 0;

  if (_size > 0)
  {
    data = new float* [_size];
    for (int i = 0 ; i < _size ; i++)
      data[i] = new float[16];
    for (int i = 0 ; i < _size ; i++)
      for (int j = 0 ; j<16 ; j++)
	data[i][j] = 0;
    size = _size;
  }  
}

  
/* *******************************************************************************
**
** operator[] 
**
******************************************************************************* */

float *Utterance::operator[](int index) const
{
  return data[index];
}

  
/* *******************************************************************************
**
** operator<< 
**
******************************************************************************* */

QDataStream& operator<<(QDataStream& out, const Utterance *s)
{
  int size = s->get_size();

  out << size;
  for (int i = 0 ; i < size ; i++)
    for (int j = 0 ; j < 16 ; j++)
      out << s->get_data(i,j);
  
  return out;
}


/* *******************************************************************************
**
** operator>>
**
******************************************************************************* */

QDataStream& operator>>(QDataStream& in, Utterance *r)
{
  int size;
  in >> size;
  r->set_size(size);
  for (int i = 0 ; i < size ; i++)
    for (int j = 0 ; j < 16 ; j++)
    {
      float f;
      in >> f;
      r->set_data(i,j,f);
    }
  
  return in;
}
